% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_read.R
\name{qc_read}
\alias{qc_read}
\title{Read FastQC Data}
\usage{
qc_read(file, modules = "all", verbose = TRUE)
}
\arguments{
\item{file}{Path to the file to be imported. Can be the path to either :
\itemize{
  \item the fastqc zipped file (e.g.: 'path/to/samplename_fastqc.zip'). No need to unzip,
  \item or the unzipped folder name (e.g.: 'path/to/samplename_fastqc'),
  \item or the sample name (e.g.: 'path/to/samplename' )
  \item or the fastqc_data.txt file,
  }}

\item{modules}{Character vector containing the names of FastQC modules for
  which you want to import/inspect the data. Default is all. Allowed values include
  one or the combination of:
  \itemize{
   \item "Summary",
   \item "Basic Statistics",
   \item "Per base sequence quality",
   \item "Per tile sequence quality",
   \item "Per sequence quality scores",
   \item "Per base sequence content",
   \item "Per sequence GC content",
   \item "Per base N content",
   \item "Sequence Length Distribution",
   \item "Sequence Duplication Levels",
   \item "Overrepresented sequences",
   \item "Adapter Content",
   \item "Kmer Content"
  }
Partial match of module names allowed. For example,
you can use modules = "GC content", instead of the full names modules = "Per sequence GC content".}

\item{verbose}{logical value. If TRUE, print filename when reading.}
}
\value{
Returns a list of tibbles containing the data for specified modules.
}
\description{
Read FastQC data into R.
}
\examples{
# Demo file
qc.file <- system.file("fastqc_results", "S1_fastqc.zip",  package = "fastqcr")
qc.file
# Read all modules
qc_read(qc.file)

# Read a specified module
qc_read(qc.file,"Per base sequence quality")

}
