% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{get_dictionary}
\alias{get_dictionary}
\title{Get list of known words}
\usage{
get_dictionary(model)
}
\arguments{
\item{model}{trained \code{fastText} model}
}
\value{
\link{character} containing each word
}
\description{
Get a \link{character} containing each word seen during training.
}
\examples{

library(fastrtext)
model_test_path <- system.file("extdata", "model_classification_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
print(head(get_dictionary(model), 5))

}
