% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{likelihood.linkdat}
\alias{likelihood.linkdat}
\alias{likelihood.singleton}
\title{Pedigree likelihood}
\usage{
likelihood.linkdat(
  x,
  locus1,
  locus2 = NULL,
  theta = NULL,
  startdata = NULL,
  eliminate = 0,
  logbase = NULL,
  loop_breakers = NULL,
  ...
)

likelihood.singleton(x, locus1, logbase = NULL, ...)
}
\arguments{
\item{x}{a \code{linkdat} object, a singleton object, or
a list of such objects. In \code{likelihood_LINKAGE}, \code{x} must be a
\code{linkdat} object, with \code{x$model} different from NULL.}

\item{locus1}{a \code{marker} object compatible with \code{x}. If
\code{x} is a list, then \code{locus1} must be a list of corresponding
\code{marker} objects.}

\item{locus2}{either NULL, the character 'disease', or a markerfb
object compatible with \code{x}. See Details.}

\item{theta}{the recombination rate between locus1 and locus2 (in
\code{likelihood_LINKAGE}: between the marker and the disease locus).  To
make biological sense theta should be between 0 and 0.5.}

\item{startdata}{for internal use.
linkage computations with few-allelic markers.}

\item{eliminate}{mostly for internal use: a non-negative integer indicating
the number of iterations in the internal genotype-compatibility algorithm.
Positive values can save time if \code{partialmarker} is non-empty and the
number of alleles is large.}

\item{logbase}{a numeric, or NULL. If numeric the log-likelihood is returned,
with \code{logbase} as basis for the logarithm.}

\item{loop_breakers}{a numeric containing IDs of individuals to be used as
loop breakers. If NULL, automatic selection of loop breakers will be
performed.}

\item{\dots}{further arguments.}
}
\value{
The likelihood of the data. If the parameter \code{logbase} is a
positive number, the output is \code{log(likelihood, logbase)}.
}
\description{
Calculates various forms of pedigree likelihoods based on paramlink functions.
}
\details{
All likelihoods are calculated using the Elston-Stewart algorithm.
}
