% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerfb.R
\name{markers}
\alias{markers}
\alias{markerfb}
\alias{addMarkerfb}
\alias{SetMarkersfb}
\alias{modifyMarkerfb}
\alias{getMarkersfb}
\alias{removeMarkersfb}
\alias{swapGenotypesfb}
\alias{modifyMarkerfbMatrix}
\title{Marker functions}
\usage{
markerfb(
  x,
  ...,
  allelematrix,
  alleles = NULL,
  afreq = NULL,
  missing = 0,
  chrom = NA,
  pos = NA,
  name = NA,
  mutmat = NULL
)

addMarkerfb(x, m, ...)

SetMarkersfb(x, m, annotations = NULL, missing = 0)

modifyMarkerfb(x, marker, ids, genotype, alleles, afreq, chrom, name, pos)

getMarkersfb(
  x,
  markernames = NULL,
  chroms = NULL,
  fromPos = NULL,
  toPos = NULL
)

removeMarkersfb(
  x,
  markers = NULL,
  markernames = NULL,
  chroms = NULL,
  fromPos = NULL,
  toPos = NULL
)

swapGenotypesfb(x, ids)

modifyMarkerfbMatrix(x, ids, new.alleles)
}
\arguments{
\item{x}{a \code{\link{linkdat}} object}

\item{...}{an even number of vectors, indicating individuals and their
genotypes. See examples.}

\item{allelematrix}{a matrix with one row per pedigree member and two columns
per marker, containing the alleles for a single marker.}

\item{alleles}{a numeric or character vector containing allele names.}

\item{afreq}{a numerical vector with allele frequencies. An error is given if
they don't sum to 1 (rounded to 3 decimals).}

\item{missing}{a numeric - or character - of length 1, indicating the code
for missing alleles.}

\item{chrom}{NA or an integer (the chromosome number of the marker).}

\item{pos}{NA or a non-negative real number indicating the genetic position
(in cM) of the marker.}

\item{name}{NA or a character (the name of the marker).}

\item{mutmat}{a mutation matrix, or a list of two such matrices named
'female' and 'male'. The matrix/matrices must be square, with the allele
labels as dimnames, and each row must sum to 1 (after rounding to 3
decimals).}

\item{m}{a \code{marker} object or a matrix with alleles. (In
\code{SetMarkersfb} this matrix can contain data of several markers.)}

\item{annotations}{a list of marker annotations.}

\item{marker, markers}{a numeric indicating which marker(s) to use/modify.}

\item{ids}{a numeric indicating individual(s) to be modified. In
\code{swapGenotypesfb} this must have length 2.}

\item{genotype}{a vector of length 1 or 2, containing the genotype to be
given the \code{ids} individuals. See examples.}

\item{markernames}{NULL or a character vector.}

\item{chroms}{NULL or a numeric vector of chromosome numbers.}

\item{fromPos, toPos}{NULL or a single numeric.}

\item{new.alleles}{a numerical matrix of dimensions \code{length(ids),
2*x$nMark}. Entries refer to the internal allele numbering.}
}
\value{
The \code{marker} function returns an object of class \code{marker}:
This is a numerical 2-column matrix with one row per individual, and
attributes 'alleles' (a character vector with allele names), 'nalleles'
(the number of alleles) and 'missing' (the input symbol for missing marker
alleles), 'chrom' (chromosome number), 'name' (marker identifier), 'pos'
(chromosome position in cM).

For \code{addMarker}, \code{SetMarkersfb}, \code{removeMarkersfb},
\code{modifyMarkerfb}, \code{modifyMarkerfbMatrix} and \code{swapGenotypesfb}, a
\code{linkdat} object is returned, whose \code{markerdata} element has been
set/modified.

For \code{getMarkersfb} a numeric vector containing marker numbers (i.e.
their indices in \code{x$markerdata}) for the markers whose 'name'
attribute is contained in \code{markernames}, 'chrom' attribute is
contained in \code{chroms}, and 'pos' attribute is between \code{from} and
\code{to}. NULL arguments are skipped, so \code{getMarkersfb(x)} will return
\code{seq_len(x$nMark)} (i.e. all markers).
}
\description{
Functions for setting and manipulating marker genotypes for 'linkdat'
objects compatible with fbnet. It was extracted from paramlink package, no longer maintained.
}
\seealso{
\code{\link{linkdat}}
}
