% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concept_set.R
\name{ConceptSet}
\alias{ConceptSet}
\title{R6 class for a set of concepts}
\description{
This class implements the data structure and methods for concept sets.
}
\examples{
# Build a formal context
fc_planets <- FormalContext$new(planets)

# Find the concepts
fc_planets$find_concepts()

# Find join- and meet- irreducible elements
fc_planets$concepts$join_irreducibles()
fc_planets$concepts$meet_irreducibles()


}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ConceptSet$new()}}
\item \href{#method-size}{\code{ConceptSet$size()}}
\item \href{#method-is_empty}{\code{ConceptSet$is_empty()}}
\item \href{#method-extents}{\code{ConceptSet$extents()}}
\item \href{#method-intents}{\code{ConceptSet$intents()}}
\item \href{#method-print}{\code{ConceptSet$print()}}
\item \href{#method-to_latex}{\code{ConceptSet$to_latex()}}
\item \href{#method-to_list}{\code{ConceptSet$to_list()}}
\item \href{#method-[}{\code{ConceptSet$[()}}
\item \href{#method-sub}{\code{ConceptSet$sub()}}
\item \href{#method-support}{\code{ConceptSet$support()}}
\item \href{#method-clone}{\code{ConceptSet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{ConceptLattice} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$new(extents, intents, objects, attributes, I = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extents}}{(\code{dgCMatrix}) The extents of all concepts}

\item{\code{intents}}{(\code{dgCMatrix}) The intents of all concepts}

\item{\code{objects}}{(character vector) Names of the objects in the formal context}

\item{\code{attributes}}{(character vector) Names of the attributes in the formal context}

\item{\code{I}}{(\code{dgCMatrix}) The matrix of the formal context}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ConceptLattice} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-size"></a>}}
\if{latex}{\out{\hypertarget{method-size}{}}}
\subsection{Method \code{size()}}{
Size of the Lattice
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The number of concepts in the lattice.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_empty"></a>}}
\if{latex}{\out{\hypertarget{method-is_empty}{}}}
\subsection{Method \code{is_empty()}}{
Is the lattice empty?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$is_empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the lattice has no concepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-extents"></a>}}
\if{latex}{\out{\hypertarget{method-extents}{}}}
\subsection{Method \code{extents()}}{
Concept Extents
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$extents()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The extents of all concepts, as a \code{dgCMatrix}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intents"></a>}}
\if{latex}{\out{\hypertarget{method-intents}{}}}
\subsection{Method \code{intents()}}{
Concept Intents
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$intents()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The intents of all concepts, as a \code{dgCMatrix}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the Concept Set
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing, just prints the concepts
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_latex"></a>}}
\if{latex}{\out{\hypertarget{method-to_latex}{}}}
\subsection{Method \code{to_latex()}}{
Write in LaTeX
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$to_latex(print = TRUE, ncols = 1, numbered = TRUE, align = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{print}}{(logical) Print to output?}

\item{\code{ncols}}{(integer) Number of columns of the output.}

\item{\code{numbered}}{(logical) Number the concepts?}

\item{\code{align}}{(logical) Align objects and attributes independently?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{LaTeX} code to list all concepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-to_list}{}}}
\subsection{Method \code{to_list()}}{
Returns a list with all the concepts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$to_list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of concepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-["></a>}}
\if{latex}{\out{\hypertarget{method-[}{}}}
\subsection{Method \code{[()}}{
Subsets a ConceptSet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$[(indices)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{indices}}{(numeric or logical vector) The indices of the concepts to return as a list of Concepts. It can be a vector of logicals where \code{TRUE} elements are to be retained.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Another ConceptSet.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sub"></a>}}
\if{latex}{\out{\hypertarget{method-sub}{}}}
\subsection{Method \code{sub()}}{
Individual Concepts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$sub(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{(numeric) The index of the concept to return.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The Concept.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-support"></a>}}
\if{latex}{\out{\hypertarget{method-support}{}}}
\subsection{Method \code{support()}}{
Get support of each concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$support()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with the support of each concept.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
