% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.DTW.R
\name{metric.DTW}
\alias{metric.DTW}
\alias{metric.WDTW}
\alias{metric.TWED}
\title{DTW: Dynamic time warping}
\usage{
metric.DTW(fdata1, fdata2 = NULL, p = 2, w = min(ncol(fdata1),
  ncol(fdata2)))

metric.WDTW(fdata1, fdata2 = NULL, p = 2, w = min(ncol(fdata1),
  ncol(fdata2)), wmax = 1, g = 0.05)

metric.TWED(fdata1, fdata2 = NULL, p = 2, lambda = 1, nu = 0.05)
}
\arguments{
\item{fdata1}{Functional data 1 or curve 1. If \code{fdata} class, the dimension of \code{fdata1$data} object is (\code{n1} x \code{m}), where \code{n1} is the number of curves and \code{m} are the points observed in each curve.}

\item{fdata2}{Functional data 2 or curve 2. If \code{fdata} class, the dimension of \code{fdata2$data} object is (\code{n2} x \code{m}), where \code{n2} is the number of curves and \code{m} are the points observed in each curve.}

\item{p}{Lp norm, by default it uses \code{p = 2}}

\item{w}{Vector of weights with length \code{m}, If \code{w = 1} approximates the metric Lp by Simpson's rule. By default it uses \code{w = 1}}

\item{wmax}{\code{numeric} maximum value of weight, (1 by default)}

\item{g}{\code{numeric} \code{g=0} (constant), \code{0.05} (linear) by default, 0.25 \code{sigmoid}, 3 two weight values}

\item{lambda}{\code{numeric} lambda value (0 by default)}

\item{nu}{\code{numeric} constant value, (0 by default)}
}
\value{
DTW matrix
}
\description{
Computes distances time warping for functional data
}
\details{
Three optins:
\itemize{
  \item DTW: Dynamic time warping
  \item WDTW: Weight Dynamic time warping
  \item TWED: twed   
}
}
\examples{
\dontrun{
data(tecator)
metric.DTW(tecator$absorp.fdata[1:4,])
ab=tecator[[1]]
D1=fda.usc:::DTW(ab$data[1,],ab$data[2,],p=2)
aa1=fda.usc:::findPath(D1$D)
D2=fda.usc:::DTW(ab$data[1,],ab$data[2,],p=2,w=5)
aa2=fda.usc:::findPath(D2$D)
D3=fda.usc:::WDTW(ab$data[1,],ab$data[2,],p=2,g=0.05) 
aa3=fda.usc:::findPath(D3$D)
D4=fda.usc:::TWED(ab$data[1,],ab$data[2,],p=2,lambda=0,nu=0)
aa4=fda.usc:::findPath(D4$D)
par(mfrow=c(2,2))
plot(c(ab[1:2]))
segments(ab$argvals[aa1[,1]],ab[1]$data[aa1[,1]],ab$argvals[aa1[,2]],ab[2]$data[aa1[,2]])
plot(c(ab[1:2]))
segments(ab$argvals[aa2[,1]],ab[1]$data[aa2[,1]],ab$argvals[aa2[,2]],ab[2]$data[aa2[,2]],col=2)
plot(c(ab[1:2]))
segments(ab$argvals[aa3[,1]],ab[1]$data[aa3[,1]],ab$argvals[aa3[,2]],ab[2]$data[aa3[,2]],col=3)
plot(c(ab[1:2]))
segments(ab$argvals[aa4[,1]],ab[1]$data[aa4[,1]],ab$argvals[aa4[,2]],ab[2]$data[aa4[,2]],col=4)
}

}
\references{
Jeong, Y. S., Jeong, M. K., & Omitaomu, O. A. (2011). Weighted dynamic time warping for 
time series classification. \emph{Pattern Recognition}, 44(9), 2231-2240
}
\seealso{
See also  \code{\link{semimetric.basis}} and \code{\link{semimetric.NPFDA}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente \email{manuel.oviedo@usc.es}
}
\keyword{cluster}
