% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata.bootstrap.r
\name{fdata.bootstrap}
\alias{fdata.bootstrap}
\alias{fdata.bootstrap2}
\title{Bootstrap samples of a functional statistic}
\usage{
fdata.bootstrap(
  fdataobj,
  statistic = func.mean,
  alpha = 0.05,
  nb = 200,
  smo = 0,
  draw = FALSE,
  draw.control = NULL,
  ...
)
}
\arguments{
\item{fdataobj}{\code{fdata} class object.}

\item{statistic}{Sample statistic. It must be a function that returns an
object of class \code{fdata}. By default, it uses sample mean
\code{\link{func.mean}}.  See \code{\link{Descriptive}} for other
statistics.}

\item{alpha}{Significance value.}

\item{nb}{Number of bootstrap resamples.}

\item{smo}{The smoothing parameter for the bootstrap samples as a proportion
of the sample variance matrix.}

\item{draw}{If \code{TRUE}, plot the bootstrap samples and the statistic.}

\item{draw.control}{List that it specifies the \code{col}, \code{lty} and
\code{lwd} for objects: \code{fdataobj}, \code{statistic}, \code{IN} and
\code{OUT}.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
\itemize{
\item{statistic}{ \code{fdata} class object with the statistic
estimate from \code{nb} bootstrap samples.} 
\item{dband}{ Bootstrap estimate of \code{(1-alpha)\%} distance.} 
\item{rep.dist}{ Distance from every replicate.} 
\item{resamples}{ \code{fdata} class object with the bootstrap resamples.} 
\item{fdataobj}{ \code{fdata} class object.}
}
}
\description{
provides bootstrap samples for functional data.
}
\details{
The \code{fdata.bootstrap()} computes a confidence ball using bootstrap in
the following way: 
\itemize{ 
\item Let \eqn{X_1(t),\ldots,X_n(t)}{X_1(t),...,X_n(t)} the original data and
\eqn{T=T(X_1(t),\ldots,X_n(t))}{T=T(X_1(t),...,X_n(t))} the sample' statistic.

\item Calculate the \code{nb} bootstrap resamples
\eqn{\left\{X_{1}^{*}{(t)},\cdots,X_n^*(t)\right\}}{(X*_1(t),...,X*_n(t))},
using the following scheme \eqn{X_i^*(t)=X_i(t)+Z(t)}{X*_i(t)=X_i(t)+Z(t)} 
where \eqn{Z(t)}{Z(t)} is normally distributed with mean 0 and covariance matrix
\eqn{\gamma\Sigma_x}{\gamma\Sigma_x}, where \eqn{\Sigma_x}{\Sigma_x} is the
covariance matrix of' \eqn{\left\{X_1(t),\ldots,X_n(t)\right\}}{(X*_1(t),...,X*_n(t))} 
and \eqn{\gamma}{\gamma} is the smoothing parameter.  

\item Let \eqn{T^{*j}=T(X^{*j}_1(t),...,X^{*j}_n(t))}{T^{*j}=T(X^{*j}_1(t),...,X^{*j}_n(t))}
the estimate using the \eqn{j} resample.  

\item Compute \eqn{d(T,T^{*j})}, \eqn{j=1,\ldots,nb}. Define the bootstrap 
confidence ball of level \eqn{1-\alpha}{1-\alpha} as \eqn{CB(\alpha)=X\in E}{CB(\alpha)=X \in E} 
such that \eqn{d(T,X)\leq d_{\alpha}}{d(T,X)<= d\alpha} being
\eqn{d_{\alpha}}{d\alpha} the quantile \eqn{(1-\alpha)}{(1-\alpha)} of the
distances between the bootstrap resamples and the sample estimate. 
}

The \code{fdata.bootstrap} function allows us to define a statistic
calculated on the \code{nb} resamples, control the degree of smoothing by
\code{smo} argument and represent the confidence ball with level
\eqn{1-\alpha}{1-\alpha} as those resamples that fulfill the condition of
belonging to \eqn{CB(\alpha)}{CB(\alpha)}.  The \code{statistic} used by
default is the mean (\code{\link{func.mean}}) but also other depth-based
functions can be used (see \code{help(Descriptive)}).
}
\examples{
\dontrun{
data(tecator)
absorp<-tecator$absorp.fdata
# Time consuming
#Bootstrap for Trimmed Mean with depth mode
out.boot=fdata.bootstrap(absorp,statistic=func.trim.FM,nb=200,draw=TRUE)
names(out.boot)
#Bootstrap for Median with with depth mode
control=list("col"=c("grey","blue","cyan"),"lty"=c(2,1,1),"lwd"=c(1,3,1))
out.boot=fdata.bootstrap(absorp,statistic=func.med.mode,
draw=TRUE,draw.control=control)
}
}
\references{
Cuevas A., Febrero-Bande, M. and Fraiman, R. (2007).
\emph{Robust estimation and classification for functional data via
projection-based depth notions.} Computational Statistics 22, 3: 481-496.

Cuevas A., Febrero-Bande, M., Fraiman R. 2006.  \emph{On the use of
bootstrap for estimating functions with functional data.} Computational
Statistics and Data Analysis 51: 1063-1074.

Febrero-Bande, M., Oviedo de la Fuente, M. (2012).  \emph{Statistical
Computing in Functional Data Analysis: The R Package fda.usc.} Journal of
Statistical Software, 51(4), 1-28. \url{http://www.jstatsoft.org/v51/i04/}
}
\seealso{
See Also as \code{\link{Descriptive}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{datagen}
