% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond.mode.R
\name{cond.mode}
\alias{cond.mode}
\title{Conditional mode}
\usage{
cond.mode(Fc, method = "monoH.FC", draw = TRUE)
}
\arguments{
\item{Fc}{Object estimated by \code{cond.F} function.}

\item{method}{Specifies the type of spline to be used. Possible values are
\emph{"diff"}, \emph{"fmm"}, \emph{"natural"}, \emph{"periodic"} and
\emph{"monoH.FC"}.}

\item{draw}{=TRUE, plots the conditional distribution and density function.}
}
\value{
Return the mode for conditional distribution function.
\itemize{
\item \code{mode.cond}{ Conditional mode.} 
\item \code{x}{ Grid of length \code{n} where the the conditional density function is evaluated.} 
\item \code{f}{ The conditional density function evaluated in \code{x}.}
}
}
\description{
Computes the mode for conditional distribution function.
}
\details{
The conditional mode is calculated as the maximum argument of the derivative
of the conditional distribution function (density function \code{f}).
}
\examples{
\dontrun{
n= 500
t= seq(0,1,len=101)
beta = t*sin(2*pi*t)^2
x = matrix(NA, ncol=101, nrow=n)
y=numeric(n)
x0<-rproc2fdata(n,seq(0,1,len=101),sigma="wiener")
x1<-rproc2fdata(n,seq(0,1,len=101),sigma=0.1)
x<-x0*3+x1
fbeta = fdata(beta,t)
y<-inprod.fdata(x,fbeta)+rnorm(n,sd=0.1)
prx=x[1:100];pry=y[1:100]
ind=101;ind2=101:110
pr0=x[ind];pr10=x[ind2]
ndist=161
gridy=seq(-1.598069,1.598069, len=ndist)
# Conditional Function
I=5
# Time consuming
res = cond.F(pr10[I], gridy, prx, pry, h=1)
mcond=cond.mode(res)
mcond2=cond.mode(res,method="diff")
}

}
\references{
Ferraty, F. and Vieu, P. (2006). \emph{Nonparametric functional
data analysis.} Springer Series in Statistics, New York.
}
\seealso{
See Also as: \code{\link{cond.F}}, \code{\link{cond.quantile}} and
\link[stats]{splinefun} .
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@udc.es}
}
\keyword{distribution}
