#' PACE: Principal Analysis by Conditional Expectation
#'
#' PACE package for Functional Data Analysis and Empirical Dynamics.
#' 
#' PACE is a versatile package that provides implementation of various methods
#' of Functional Data Analysis (FDA) and Empirical Dynamics. The core of this
#' package is Functional Principal Component Analysis (FPCA), a key technique
#' for functional data analysis, for sparsely or densely sampled random
#' trajectories and time courses, via the Principal Analysis by Conditional
#' Estimation (PACE) algorithm. PACE is useful for the analysis of data that
#' have been generated by a sample of underlying (but usually not fully
#' observed) random trajectories. It does not rely on pre-smoothing of
#' trajectories, which is problematic if functional data are sparsely sampled.
#' PACE provides options for functional regression and correlation, for
#' Longitudinal Data Analysis, the analysis of stochastic processes from
#' samples of realized trajectories, and for the analysis of underlying
#' dynamics.
#'
#' 
#' @author
#' Xiongtao Dai \email{dai@@ucdavis.edu},
#' Pantelis Z. Hadjipantelis \email{pantelis@@ucdavis.edu},
#' Hao Ji \email{haoji@@ucdavis.edu}
#' Hans-Georg Mueller \email{hgmueller@@ucdavis.edu}
#' Jane-Ling Wang \email{janelwang@@ucdavis.edu}
#'
#' Maintainer: Pantelis Z. Hadjipantelis \email{pantelis@@ucdavis.edu}
#'
#' @docType package
#' @name fdapace
#' @useDynLib fdapace
#' @import Hmisc plot3D Rcpp
#' @importFrom numDeriv grad
#' @importFrom pracma meshgrid midpoint mod ones uniq
NULL
