% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeGPFunctionalData.R
\name{MakeGPFunctionalData}
\alias{MakeGPFunctionalData}
\title{Make Gaussian Process Dense Functional Data sample}
\usage{
MakeGPFunctionalData(n, M = 100, mu = rep(0, M), K = 2, lambda = rep(1,
  K), sigma = 0, basisType = "cos")
}
\arguments{
\item{n}{number of samples to generate}

\item{M}{number of equidistant readings per sample (default: 100)}

\item{mu}{vector of size M specifying the mean (default: rep(0,M))}

\item{K}{scalar specifying the number of basis to be used (default: 2)}

\item{lambda}{vector of size K specifying the variance of each components (default: rep(1,K))}

\item{sigma}{The standard deviation of the Gaussian noise added to each observation points.}

\item{basisType}{string specifiying the basis type used; possible options are: 'sin', 'cos' and 'fourier' (default: 'cos') (See code of 'CreateBasis' for implementation details.)}
}
\value{
Y: X(t_{j}), Yn: noisy observations
}
\description{
Make a Gaussian process dense functional data sample of size n over a [0,1] support.
}
