% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.FPCAder.R
\name{fitted.FPCAder}
\alias{fitted.FPCAder}
\title{Fitted functional sample from FPCAder object}
\usage{
\method{fitted}{FPCAder}(object, K = NULL, ...)
}
\arguments{
\item{object}{A object of class FPCA returned by the function FPCA().}

\item{K}{The integer number of the first K components used for the representation. (default: length(derObj$lambda ))}

\item{...}{Additional arguments}
}
\value{
An \code{n} by \code{length(workGrid)} matrix, each row of which contains a sample.
}
\description{
Combine the zero-meaned fitted values and the mean derivative to get the fitted values for the derivatives trajectories
Estimates are given on the work-grid, not on the observation grid. Use ConvertSupport to map the estimates to your desired domain.
}
\examples{
set.seed(1)
n <- 20
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10)
}
\references{
\cite{Liu, Bitao, and Hans-Georg Mueller. "Estimating derivatives for samples of sparsely observed functions, with application to online auction dynamics." Journal of the American Statistical Association 104, no. 486 (2009): 704-717. (Sparse data FPCA)}
}
