% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_karcher_mean.R
\name{curve_karcher_mean}
\alias{curve_karcher_mean}
\title{Karcher Mean of Curves}
\usage{
curve_karcher_mean(beta, mode = "O", maxit = 20)
}
\arguments{
\item{beta}{array (n,T,N) for N number of curves}

\item{mode}{Open ("O") or Closed ("C") curves}

\item{maxit}{maximum number of iterations}
}
\value{
Returns a list containing \item{mu}{mean srvf}
\item{betamean}{mean curve}
\item{v}{shooting vectors}
\item{q}{array of srvfs}
}
\description{
Calculates Karcher mean of a collection of curves using the elastic square-root velocity (srvf) framework.
}
\examples{
data("mpeg7")
out = curve_karcher_mean(beta[,,1,1:2],maxit=2) # note: use more shapes, small for speed
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}

