% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_fPCA.R
\name{align_fPCA}
\alias{align_fPCA}
\title{Group-wise function alignment and PCA Extractions}
\usage{
align_fPCA(f, time, num_comp = 3, showplot = T, smooth_data = FALSE,
  sparam = 25, parallel = FALSE, cores = 8, MaxItr = 51)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{num_comp}{number of principal components to extract (default = 3)}

\item{showplot}{shows plots of functions (default = T)}

\item{smooth_data}{smooth data using box filter (default = F)}

\item{sparam}{number of times to apply box filter (default = 25)}

\item{parallel}{enable parallel mode using \code{\link{foreach}} and
\code{doParallel} package}

\item{cores}{set number of cores to use with \code{doParallel} (default = 2)}

\item{MaxItr}{maximum number of iterations}
}
\value{
Returns a list containing \item{f0}{original functions}
\item{fn}{aligned functions - matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}
\item{qn}{aligned srvfs - similar structure to fn}
\item{q0}{original srvfs - similar structure to fn}
\item{mqn}{srvf mean - vector of length \eqn{N}}
\item{gam}{warping functions - vector of length \eqn{N}}
\item{Dx}{cost function}
\item{vfpca}{list containing}
\item{q_pca}{srvf principal directions}
\item{f_pca}{f principal directions}
\item{latent}{latent values}
\item{coef}{coefficients}
\item{U}{eigenvectors}
}
\description{
This function aligns a collection of functions while extracting principal
components.
}
\examples{
data("simu_data")
out = align_fPCA(simu_data$f,simu_data$time,MaxItr = 1)  # use more iterations for accuracy
}
\references{
Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment,}
\keyword{pca}
\keyword{srvf}
