% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_karcher_cov.R
\name{curve_karcher_cov}
\alias{curve_karcher_cov}
\title{Curve Karcher Covariance}
\usage{
curve_karcher_cov(v, len = NA)
}
\arguments{
\item{v}{array (n,T,N) for N number of shooting vectors}

\item{len}{lengths of curves (default=NA)}
}
\value{
K covariance matrix
}
\description{
Calculate Karcher Covariance of a set of curves
}
\examples{
data("mpeg7")
out = curve_karcher_mean(beta[,,1,1:2], maxit=2) # note: use more shapes, small for speed
K = curve_karcher_cov(out$v)
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
