% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tolerance.R
\name{pcaTB}
\alias{pcaTB}
\title{Tolerance Bound Calculation using Elastic Functional PCA}
\usage{
pcaTB(f, time, m = 4, B = 1e+05, a = 0.05, p = 0.99)
}
\arguments{
\item{f}{matrix of functions}

\item{time}{vector describing time sampling}

\item{m}{number of principal components (default = 4)}

\item{B}{number of monte carlo iterations}

\item{a}{confidence level of tolerance bound (default = 0.05)}

\item{p}{coverage level of tolerance bound (default = 0.99)}
}
\value{
Returns a list containing \item{pca}{pca output}
\item{tol}{tolerance factor}
}
\description{
This function computes tolerance bounds for functional data containing
phase and amplitude variation using principal component analysis
}
\examples{
\dontrun{
  out1 <- pcaTB(simu_data$f, simu_data$time)
}
}
\references{
J. D. Tucker, J. R. Lewis, C. King, and S. Kurtek, “A Geometric
Approach for Computing Tolerance Bounds for Elastic Functional Data,”
Journal of Applied Statistics, 10.1080/02664763.2019.1645818, 2019.

Tucker, J. D., Wu, W., Srivastava, A., Generative Models for
Function Data using Phase and Amplitude Separation, Computational
Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.

Jung, S. L. a. S. (2016). "Combined Analysis of Amplitude and
Phase Variations in Functional Data." arXiv:1603.01775.
}
\concept{pca tolerance bounds}
