% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactoring.R
\name{to_hilbert_sphere}
\alias{to_hilbert_sphere}
\title{Projects an SRVF onto the Hilbert sphere}
\usage{
to_hilbert_sphere(qfun, qnorm = sqrt(get_l2_inner_product(qfun, qfun)))
}
\arguments{
\item{qfun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the SRVF at \eqn{s}.}

\item{qnorm}{A numeric value specifying the \eqn{L^2} norm of the SRVF.
Defaults to \eqn{\sqrt{\langle q, q \rangle}}.}
}
\value{
A function that takes a numeric vector \eqn{s} of values in \eqn{[0,
  1]} as input and returns the values of the SRVF projected onto the Hilbert
sphere.
}
\description{
Projects an SRVF onto the Hilbert sphere
}
\examples{
q <- curve2srvf(beta[, , 1, 1])
to_hilbert_sphere(q)
}
