% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactoring.R
\name{srvf2curve}
\alias{srvf2curve}
\title{Converts from SRVF to curve representation}
\usage{
srvf2curve(qfun, beta0 = NULL)
}
\arguments{
\item{qfun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the SRVF of an underlying
curve at \eqn{s}.}

\item{beta0}{A numeric vector of length \eqn{L} specifying the initial value
of the underlying curve at \eqn{s = 0}.}
}
\value{
A function that takes a numeric vector \eqn{t} of values in \eqn{[0,
  1]} as input and returns the values of the underlying curve at \eqn{t}.
}
\description{
Converts from SRVF to curve representation
}
\examples{
srvf2curve(curve2srvf(beta[, , 1, 1]))
}
