% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{predict.knn}
\alias{predict.knn}
\title{Model predictions}
\usage{
\method{predict}{knn}(object, test, fuzzy = FALSE, ...)
}
\arguments{
\item{object}{The classification model (of class \code{\link[class]{knn}}).}

\item{test}{The test set (a \code{data.frame}).}

\item{fuzzy}{A boolean indicating whether fuzzy classification is used or not.}

\item{...}{Other parameters.}
}
\value{
A vector of predicted values (\code{factor}).
}
\description{
This function predicts values based upon a model trained by \code{\link{KNN}}.
}
\examples{
require (datasets)
data (iris)
d = splitdata (iris, 5)
model = KNN (d$train.x, d$train.y)
predict (model, d$test.x)
}
\seealso{
\code{\link{KNN}}, \code{\link{knn-class}}
}
