% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{query.docs}
\alias{query.docs}
\title{Document query}
\usage{
query.docs(docvectors, query, vectorizer, nres = 5)
}
\arguments{
\item{docvectors}{The vectorized documents.}

\item{query}{The query (vectorized or raw text).}

\item{vectorizer}{The vectorizer taht has been used to vectorize the documents.}

\item{nres}{The number of results.}
}
\value{
The indices of the documents the most similar to the query.
}
\description{
Search for documents similar to the query.
}
\examples{
\dontrun{
require (text2vec)
data (movie_review)
vectorizer = vectorize.docs (corpus = movie_review$review,
                             minphrasecount = 50, returndata = FALSE)
docs = vectorize.docs (corpus = movie_review$review, vectorizer = vectorizer)
query.docs (docs, movie_review$review [1], vectorizer)
query.docs (docs, docs [1, ], vectorizer)
}
}
\seealso{
\code{\link{vectorize.docs}}, \code{\link[text2vec]{sim2}}
}
