% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{svmpolynomial4}
\alias{svmpolynomial4}
\title{Polynomial degree 4 SVM
Implements a polynomial degree 4 SVM using the general svm function (for ease of use in feature selection)}
\usage{
svmpolynomial4(data_train, data_test, includeplot = FALSE)
}
\arguments{
\item{data_train}{Training set: dataframe containing classification column and all other columns features. This is the dataset on which the decision tree model is trained.}

\item{data_test}{Test set: dataframe containing classification column and all other columns features. This is the dataset on which the decision tree model in tested.}

\item{includeplot}{Show performance scatter plot (default:FALSE)}
}
\value{
List containing performance percentages, accessed using training (training accuracy), test (test accuracy), trainsensitivity, testsensitivity, trainspecificity, testspecificity.
}
\description{
Polynomial degree 4 SVM
Implements a polynomial degree 4 SVM using the general svm function (for ease of use in feature selection)
}
\examples{
data_train = data.frame(
      classification=as.factor(c(1,1,0,0,1,1,0,0,1,1)),
      A=c(1,1,1,0,0,0,1,1,1,0),
      B=c(0,1,1,0,1,1,0,1,1,0),
      C=c(0,0,1,0,0,1,0,0,1,0))
data_test = data.frame(
      classification=as.factor(c(1,1,0,0,1,1,1,0)),
      A=c(0,0,0,1,0,0,0,1),
      B=c(1,1,1,0,0,1,1,1),
      C=c(0,0,1,1,0,0,1,1))
svmpolynomial4(data_train,data_test)
}
\keyword{classification}
\keyword{svm}
