% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_feature_matrix.R
\name{tidy_feature_matrix}
\alias{tidy_feature_matrix}
\title{Tidy feature matrix}
\usage{
tidy_feature_matrix(.data, remove_nzv = FALSE, nan_is_na = FALSE,
  clean_names = FALSE)
}
\arguments{
\item{.data}{The featuretools-object returned from \link[featuretoolsR]{dfs}.}

\item{remove_nzv}{Remove near zero variance variables created from \link[featuretoolsR]{dfs}.}

\item{nan_is_na}{Turn all `NaN` into `NA`.}

\item{clean_names}{Make variable names R-friendly (snake case).}
}
\value{
A tidy data.frame.
}
\description{
Used for tidying up ('R-ify') the feature matrix after deep feature synthethis (\link[featuretoolsR]{dfs}).
}
\examples{
\donttest{
library(magrittr)
set_1 <- data.frame(key = 1:100, value = sample(letters, 100, TRUE), stringsAsFactors = TRUE)
set_2 <- data.frame(key = 1:100, value = sample(LETTERS, 100, TRUE), stringsAsFactors = TRUE)
# Common variable: `key`

as_entityset(set_1, index = "key", entity_id = "set_1", id = "demo") \%>\%
  add_entity(entity_id = "set_2", df = set_2, index = "key") \%>\%
  add_relationship(
    parent_set = "set_1",
    child_set = "set_2",
    parent_idx = "key",
    child_idx = "key"
  ) \%>\%
  dfs(target_entity = "set_1", trans_primitives = c("and")) \%>\%
  tidy_feature_matrix(remove_nzv = TRUE, nan_is_na = TRUE)
}
}
