% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{expenditures}
\alias{expenditures}
\title{Operating Expenditures}
\format{
A data frame with 1000 rows and 20 columns:
\describe{
\item{cmte_id}{A 9-character alpha-numeric code assigned to a committee by the Federal Election Commission}
\item{amndt_ind}{Amendment indicator: Indicates if the report being filed is new (N), an amendment (A) to a previous
report or a termination (T) report}
\item{rpt_yr}{Report year}
\item{rpt_tp}{Indicates the type of report filed, listed here:
\url{https://www.fec.gov/campaign-finance-data/report-type-code-descriptions}}
\item{line_num}{Indicates FEC form line number}
\item{form_tp_cd}{Indicates FEC form type}
\item{sched_tp_cd}{Schedule type: Schedule B - Itemized disbursements}
\item{name}{Contributor/lender/Transfer Name}
\item{city}{City}
\item{state}{State}
\item{zip_code}{ZIP Code}
\item{transaction_dt}{Transaction date (YYYY-MM-DD)}
\item{transaction_amt}{Transaction Amount}
\item{transaction_pgi}{Primary general indicator}
\item{purpose}{Purpose}
\item{category}{Disbursement category code: 001-012 and 101-107}
\item{category_desc}{Disbursement Category Code Description,
listed here: \url{https://www.fec.gov/campaign-finance-data/disbursement-category-code-descriptions}}
\item{entity_tp}{Entity Type:

CAN = Candidate

CCM = Candidate Committee

COM = Committee

IND = Individual (a person)

ORG = Organization (not a committee and not a person)

PAC = Political Action Committee

PTY = Party Organization}

\item{tran_id}{Only for Electronic Filings. A unique identifier associated with each itemization or transaction
appearing in an FEC electronic file. A transaction ID is unique for a specific committee for a specific report.}

\item{back_ref_tran_id}{Back reference transaction ID: Used to associate one transaction with another transaction in the same report
(using file number, transaction ID and back reference transaction ID).
For example, a credit card payment and the sub-itemization of specific purchases.
The back reference transaction ID of the specific purchases will equal the transaction ID of the payment to the credit card company.}
}
}
\source{
\url{https://www.fec.gov/campaign-finance-data/operating-expenditures-file-description/}, updated 2020-03-02
}
\usage{
expenditures
}
\description{
Operating expenditure information for a simple random sample
of 1000 entries
}
\keyword{datasets}
