% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wgt_jaccard_distance.R
\name{wgt_jaccard_distance}
\alias{wgt_jaccard_distance}
\title{Computing Weighted Jaccard Distance}
\usage{
wgt_jaccard_distance(string_1, string_2, corpus, nthreads = 1)
}
\arguments{
\item{string_1}{character vector}

\item{string_2}{character vector}

\item{corpus}{corpus data.table, constructed with
\code{fedmatch::build_corpus}}

\item{nthreads}{number of threads to use in the underlying C++ code}
}
\value{
numeric vector with the Weighted Jaccard distances for each element
of string_1 and string_2.
}
\description{
#' \code{wgt_jaccard_distance} computes the Weighted Jaccard Distance between
two strings. It is vectorized, and accepts only two equal-length string
vectors.
}
\details{
See the vignette \code{fuzzy_matching} for details on how the Weighted Jaccard similarity is computed.
}
