% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_projects_multiple.R
\name{fe_projects_multiple}
\alias{fe_projects_multiple}
\title{Fetch multiple projects by internal Federal RePORTER IDs (SM ID
or Project Numbers)}
\usage{
fe_projects_multiple(internal_id = NULL, project_number = NULL,
  secure = TRUE)
}
\arguments{
\item{internal_id}{internal Federal 'RePORTER' generated unique ID
associated with each project. It is available as part of
export on Federal RePORTER search results. Example, 739576.}

\item{project_number}{unique number that is assigned to a project
by the affiliated federal agency. Examples: \code{'5R01MH092950-05'},
\code{'1R01CA183929-01A1'}, \code{'USFS-0000779'}.}

\item{secure}{passed to \code{\link{fe_base_url}} for https}
}
\value{
List of the result of the \code{\link{GET}} call and
the content
}
\description{
Fetch multiple projects by internal Federal RePORTER IDs (SM ID
or Project Numbers)
}
\note{
See
\url{https://api.federalreporter.nih.gov/#!/Projects/Get_Project},
this calls \code{POST /v1/projects/FetchBySmApplIds}
}
\examples{
res = fe_projects_multiple(
project_number = c("5R01MH092950-05", "USFS-0000779")
)
res = fe_projects_multiple(
internal_id = c("739576", "739577")
)
}
