% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{felt_add_map_layers}
\alias{felt_add_map_layers}
\title{Add Layers to Existing Map}
\usage{
felt_add_map_layers(
  map_id,
  name = NULL,
  file_names = NULL,
  fill_color = NULL,
  stroke_color = NULL
)
}
\arguments{
\item{map_id}{map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{name}{Name of the layer}

\item{file_names}{Files to include}

\item{fill_color}{Color to fill shape with, typically a hexcode. Defaults to \code{NULL}.v}

\item{stroke_color}{Color to outline shape with, typically a hexcode. Defaults to \code{NULL}.}
}
\value{
a string with the id for the created layer
}
\description{
Add Layers to Existing Map
}
\examples{
\dontshow{if (has_felt_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
felt_add_map_layers(map_id = 'Rockland-2024-Districts-TBI8sDkmQjuK2GX9CSiHiUA',
                    file_names = fs::path_package('feltr',  'towns.geojson'),
                    name = 'Towns')
\dontshow{\}) # examplesIf}
}
