\name{Steady-State}
\alias{read.st1}
\alias{plot.st1}
\alias{print.st1}

\title{Steady state output}
\description{
  Using SolveSteady = TRUE in FEMME a .st1 file is generated which
  can be read and further processed with these functions
}
\usage{
read.st1(st1file)

plot.st1(x,xvari=1,yvari=2,rev="",type='l',obs=NULL,pch=16,main=x$filename,
xlab=NULL,ylab=NULL,xlim=NULL,ylim=NULL,mar=NULL,oma=NULL,obsname=obs$filename,...)
}
\arguments{
  \item{st1file}{File ending in .st1 generated by FEMME}
  \item{x}{object of class st1 created by \code{read.st1}}
  \item{xvari}{Index of X Variable}
  \item{yvari}{Index of Y Variable}
  \item{rev}{Reversion of axis}
  \item{obs}{Observation object created by \code{read.obs}}
  \item{obsname}{Name of observation for title}
  \item{main}{Main title}
  \item{xlab}{X axis label}
  \item{ylab}{Y axis label}
  \item{xlim}{Limits of the X axis}
  \item{ylim}{Limits of the Y axis}
  \item{mar}{Inner margins}
  \item{oma}{Outer margins}
  \item{type}{Plot type}
  \item{pch}{Plotting character}
  \item{...}{Additional plot parameters}
}
\details{
}

\value{
\code{read.st1} returns a list with components
\item{data}{Modelled data}
\item{vars}{Variable names}
\item{units}{Variable units}
\item{filename}{Filename}
}
\references{Soetaert et al, 2002}
\author{Henrik Andersson <h.andersson@nioo.knaw.nl>}
\note{Use at your own risk}
\seealso{\code{\link{read.obs}}}
\examples{
## test.st1 <- read.st1("blaha.st1")
## plot(test.st1)

## For examples see: vignette("femmeR")
}
\keyword{file}
\keyword{misc}
\keyword{hplot}

