% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_interrupt}
\alias{get_interrupt}
\title{Extract the end point of the interpolation and the target point in the iteration when an interruption happens}
\usage{
get_interrupt(dt, group = NULL, precision = 0.001)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}

\item{group}{the variable to label different runs of the optimiser(s)}

\item{precision}{numeric; if the index value of the last interpolating point and the anchor point differ by \code{precision}, an interruption is registered}
}
\value{
a tibble object containing the target and anchor bases for the iteration when an interruption happens
}
\description{
The optimiser can find better basis on the interpolation path, an interruption is
implemented to stop further interpolation from the highest point to the target point.
This discrepancy is highlighted in the PCA plot. You should not use geodesic search on this function.
}
\examples{
holes_1d_better \%>\% get_interrupt()
holes_1d_geo \%>\% get_interrupt()
}
\seealso{
Other get functions: 
\code{\link{get_anchor}()},
\code{\link{get_basis_matrix}()},
\code{\link{get_best}()},
\code{\link{get_dir_search}()},
\code{\link{get_interp_last}()},
\code{\link{get_interp}()},
\code{\link{get_search_count}()},
\code{\link{get_search}()},
\code{\link{get_space_param}()},
\code{\link{get_start}()},
\code{\link{get_theo}()}
}
\concept{get functions}
