% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog.R
\encoding{UTF-8}
\name{print.dcat}
\alias{print.dcat}
\title{Print a data catalog}
\usage{
\method{print}{dcat}(x, ..., verbose = FALSE)
}
\arguments{
\item{x}{The catalog to print.}

\item{...}{Any follow-on parameters.}

\item{verbose}{Whether or not to print the catalog in verbose style.
By default, the parameter is FALSE, meaning to print in summary style.}
}
\value{
The object, invisibly.
}
\description{
A class-specific instance of the \code{print} function for 
a data catalog.  The function prints the catalog in a summary manner.  
Use \code{verbose = TRUE} option to print the catalog as a list.
}
\examples{
# Get data directory
pkg <- system.file("extdata", package = "fetch")

# Create catalog
ct <- catalog(pkg, engines$csv)

# View catalog
print(ct)
# data catalog: 6 items
# - Source: C:/packages/fetch/inst/extdata
# - Engine: csv
# - Items:
  # data item 'ADAE': 56 cols 150 rows
  # data item 'ADEX': 17 cols 348 rows
  # data item 'ADPR': 37 cols 552 rows
  # data item 'ADPSGA': 42 cols 695 rows
  # data item 'ADSL': 56 cols 87 rows
  # data item 'ADVS': 37 cols 3617 rows

}
