% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{search_metadata}
\alias{search_metadata}
\title{Search Metadata}
\usage{
search_metadata(filter_list = list(), ..., operation = "eq")
}
\arguments{
\item{filter_list}{an optional named list that can be passed to search_metadata in addition
to explicitly named parameters}

\item{...}{any valid field name}

\item{operation}{optional parameter that allows one to specify the given
the method of comparison for search, "equals" is the default}
}
\value{
returns list of names of all variables that match specified parameter values
}
\description{
search_metadata allows users to retrieve a list of
variable names based on whether or not those variables contain a given query or set of
queries within a given field or set of fields
}
\details{
List of valid field names:
\itemize{
    \item{data_source}
    \item{data_type}
    \item{fp_PCG}
    \item{fp_father}
    \item{fp_fchild}
    \item{fp_mother}
    \item{fp_other}
    \item{fp_partner}
    \item{group_id}
    \item{group_subid}
    \item{id}
    \item{label}
    \item{leaf}
    \item{measures}
    \item{name}
    \item{old_name}
    \item{probe}
    \item{qText}
    \item{respondent}
    \item{scope}
    \item{section}
    \item{warning}
    \item{wave}
}
}
\examples{
search_test1 <- search_metadata(wave = "Year 1")

search_test2 <- search_metadata(wave = "Year 1", respondent = "Mother")

search_test3 <- search_metadata(wave = "Year 1", name = "f\%", operation = c("eq", "like"))

search_test4 <- search_metadata(name = "f1\%", operation = "like")

# Note that when using operators checking for null values (or lack thereof), the operation
# parameter should not be included in the call. It should be formatted instead like so:
search_test5 <- search_metadata(qtext = "is_null")
}
