% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_import_dp.R
\name{dp_cleannames}
\alias{dp_cleannames}
\alias{dp_clean_names}
\title{Clean Names}
\usage{
dp_cleannames(
  player_name,
  lowercase = FALSE,
  convert_lastfirst = TRUE,
  use_name_database = TRUE
)

dp_clean_names(
  player_name,
  lowercase = FALSE,
  convert_lastfirst = TRUE,
  use_name_database = TRUE
)
}
\arguments{
\item{player_name}{a character (or character vector)}

\item{lowercase}{defaults to FALSE - if TRUE, converts to lowercase}

\item{convert_lastfirst}{converts names from "Last, First" to "First Last" (i.e. MFL style)}

\item{use_name_database}{uses internal name database to do common substitutions (Mitchell Trubisky to Mitch Trubisky etc)}
}
\value{
a character vector of cleaned names
}
\description{
Applies some name-cleaning heuristics to facilitate joins. These heuristics may include:
\itemize{
\item removing periods and apostrophes
\item removing common suffixes, such as Jr, Sr, II, III, IV
\item converting to lowercase
\item using \code{dp_name_mapping} to do common name substitutions, such as Mitch Trubisky to Mitchell Trubisky
}
}
\examples{
\donttest{
dp_cleannames(c("A.J. Green", "Odell Beckham Jr.", "Le'Veon Bell Sr."))

dp_cleannames(c("Trubisky, Mitch", "Atwell, Chatarius", "Elliott, Zeke", "Elijah Moore"),
              convert_lastfirst = TRUE,
              use_name_database = TRUE)
}

}
\seealso{
\code{dp_name_mapping}
}
