% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_franchises.R,
%   R/flea_franchises.R, R/mfl_franchises.R, R/sleeper_franchises.R
\name{ff_franchises}
\alias{ff_franchises}
\alias{ff_franchises.espn_conn}
\alias{ff_franchises.flea_conn}
\alias{ff_franchises.mfl_conn}
\alias{ff_franchises.sleeper_conn}
\title{Get League Franchises}
\usage{
ff_franchises(conn)

\method{ff_franchises}{espn_conn}(conn)

\method{ff_franchises}{flea_conn}(conn)

\method{ff_franchises}{mfl_conn}(conn)

\method{ff_franchises}{sleeper_conn}(conn)
}
\arguments{
\item{conn}{a conn object created by \code{ff_connect()}}
}
\value{
A tidy dataframe of franchises, complete with IDs
}
\description{
Return franchise-level data (including divisions, usernames, etc) - available data may vary slightly based on platform.
}
\section{Methods (by class)}{
\itemize{
\item \code{espn_conn}: ESPN: returns franchise and division information.

\item \code{flea_conn}: Fleaflicker: returns franchise and division information.

\item \code{mfl_conn}: MFL: returns franchise and division information.

\item \code{sleeper_conn}: Sleeper: retrieves a list of franchise information, including user IDs and co-owner IDs.
}}

\examples{
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird

  conn <- espn_connect(season = 2020, league_id = 1178049)

  ff_franchises(conn)

}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
conn <- fleaflicker_connect(season = 2020, league_id = 206154)
ff_franchises(conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
ssb_conn <- ff_connect(platform = "mfl", league_id = 54040, season = 2020)
ff_franchises(ssb_conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
jml_conn <- ff_connect(platform = "sleeper", league_id = "522458773317046272", season = 2020)
ff_franchises(jml_conn)
}) # end try
}

}
