% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_projections.R
\name{ffs_generate_projections}
\alias{ffs_generate_projections}
\title{Generate Projections}
\usage{
ffs_generate_projections(
  adp_outcomes,
  latest_rankings,
  n_seasons = 100,
  n_weeks = 14,
  rosters = NULL
)
}
\arguments{
\item{adp_outcomes}{a dataframe of adp-based weekly outcomes, as created by \code{ffs_adp_outcomes()}}

\item{latest_rankings}{a dataframe of rankings, as created by \code{ffs_latest_rankings()}}

\item{n_seasons}{number of seasons, default is 100}

\item{n_weeks}{weeks per season, default is 14}

\item{rosters}{a dataframe of rosters, as created by \code{ffs_rosters()} - optional, reduces computation to just rostered players}
}
\value{
a dataframe of weekly scores for each player in the simulation, approximately of length n_seasons x n_weeks x latest_rankings
}
\description{
Runs the bootstrapped resampling of player week outcomes on the latest rankings and rosters for a given number of seasons and weeks per season.
}
\examples{
\donttest{
# cached examples
adp_outcomes <- .ffs_cache("adp_outcomes.rds")
latest_rankings <- .ffs_cache("latest_rankings.rds")

ffs_generate_projections(adp_outcomes,latest_rankings)
}

}
\seealso{
vignette("Custom Simulations") for example usage
}
