% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_ff_wins_added.R
\name{ff_wins_added}
\alias{ff_wins_added}
\title{Wins Added}
\usage{
ff_wins_added(conn, ...)
}
\arguments{
\item{conn}{an connection to a league made with \code{ff_connect()} and friends (required)}

\item{...}{
  Arguments passed on to \code{\link[=ff_simulate]{ff_simulate}}
  \describe{
    \item{\code{n_seasons}}{number of seasons to simulate, default = 100}
    \item{\code{n_weeks}}{number of weeks per season, default = 14}
    \item{\code{best_ball}}{a logical: are weekly wins based on optimal lineups?}
    \item{\code{seed}}{an integer to control reproducibility}
    \item{\code{gp_model}}{select between "simple", "none" to apply a model for whether a player played in a given game, defaults to "simple"}
    \item{\code{base_seasons}}{a numeric vector that selects seasons as base data, earliest available is 2012}
    \item{\code{actual_schedule}}{a logical: use actual ff_schedule? default is FALSE}
    \item{\code{replacement_level}}{a logical: use best available on waiver as  replacement level? defaults to TRUE}
    \item{\code{pos_filter}}{a character vector of positions to filter/run, default is c("QB","RB","WR","TE","K")}
    \item{\code{verbose}}{a logical: print status messages? default is TRUE, configure with options(ffsimulator.verbose)}
    \item{\code{return}}{one of c("default", "all") - what objects to return in the output list}
  }}
}
\value{
a dataframe summarising the net effect of each player on their team's wins
}
\description{
(EXPERIMENTAL) This function adds a basic wins-added calculation for each player on every team, presenting the change in wins if that player was removed from the team as the net wins-over-replacement for that player. This can be a bit of a time/compute-expensive calculation.
}
\details{
Runs base simulation once (with the usual parameters available for ff_simulate), then for every player on every team (except replacement level players):
\itemize{
\item remove them from that specific roster
\item reoptimize the lineups just for that roster without the player to calculate what the score ends up being without the player
\item summarise the new simulation
\item return the delta in wins and points
}

Summarise wins added as the difference between the sim with the player and the sim without them
}
\examples{
\donttest{
try({ # try block to prevent CRAN-related issues
# n_seasons set so that the example runs more quickly
ff_wins_added(mfl_connect(2021,54040), n_seasons = 5)
})
}

}
