% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_dbh_bubbles}
\alias{theme_dbh_bubbles}
\title{Theme for \code{theme_dbh_bubbles()}.}
\usage{
theme_dbh_bubbles(axis.text = element_blank(),
  panel.background = element_rect(fill = "white"),
  panel.grid.minor = element_blank(),
  panel.grid.major = element_blank(), legend.position = "none",
  plot.title = element_text(size = 20),
  plot.subtitle = element_text(size = 12),
  panel.border = element_rect(colour = "black", fill = NA),
  axis.ticks.length = unit(-0.1, "cm"), ...)
}
\arguments{
\item{axis.text}{tick labels along axes (\code{\link[=element_text]{element_text()}}). Specify all axis tick labels (\code{axis.text}),
tick labels by plane (using \code{axis.text.x} or \code{axis.text.y}), or individually
for each axis (using \code{axis.text.x.bottom}, \code{axis.text.x.top},
\code{axis.text.y.left}, \code{axis.text.y.right}). \code{axis.text.*.*} inherits from
\code{axis.text.*} which inherits from \code{axis.text}, which in turn inherits
from \code{text}}

\item{panel.background}{background of plotting area, drawn underneath plot
(\code{\link[=element_rect]{element_rect()}}; inherits from \code{rect})}

\item{panel.grid.minor}{grid lines (\code{\link[=element_line]{element_line()}}). Specify major grid lines,
or minor grid lines separately (using \code{panel.grid.major} or \code{panel.grid.minor})
or individually for each axis (using \code{panel.grid.major.x}, \code{panel.grid.minor.x},
\code{panel.grid.major.y}, \code{panel.grid.minor.y}).  Y axis grid lines are horizontal
and x axis grid lines are vertical. \code{panel.grid.*.*} inherits from
\code{panel.grid.*} which inherits from \code{panel.grid}, which in turn inherits
from \code{line}}

\item{panel.grid.major}{grid lines (\code{\link[=element_line]{element_line()}}). Specify major grid lines,
or minor grid lines separately (using \code{panel.grid.major} or \code{panel.grid.minor})
or individually for each axis (using \code{panel.grid.major.x}, \code{panel.grid.minor.x},
\code{panel.grid.major.y}, \code{panel.grid.minor.y}).  Y axis grid lines are horizontal
and x axis grid lines are vertical. \code{panel.grid.*.*} inherits from
\code{panel.grid.*} which inherits from \code{panel.grid}, which in turn inherits
from \code{line}}

\item{legend.position}{the position of legends ("none", "left", "right",
"bottom", "top", or two-element numeric vector)}

\item{plot.title}{plot title (text appearance) (\code{\link[=element_text]{element_text()}}; inherits
from \code{title}) left-aligned by default}

\item{plot.subtitle}{plot subtitle (text appearance) (\code{\link[=element_text]{element_text()}};
inherits from \code{title}) left-aligned by default}

\item{panel.border}{border around plotting area, drawn on top of plot so that
it covers tick marks and grid lines. This should be used with
\code{fill = NA}
(\code{\link[=element_rect]{element_rect()}}; inherits from \code{rect})}

\item{axis.ticks.length}{length of tick marks (\code{unit})}

\item{...}{additional element specifications not part of base ggplot2. If
supplied \code{validate} needs to be set to \code{FALSE}.}
}
\description{
Theme for \code{theme_dbh_bubbles()}.
}
\examples{
class(theme_dbh_bubbles())
}
\seealso{
Other functions to plot dbh bubbles: \code{\link{header_dbh_bubbles}},
  \code{\link{plot_dbh_bubbles_by_quadrat}}
}
\concept{functions to plot dbh bubbles}
\keyword{internal}
