% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\name{fhir_serialize}
\alias{fhir_serialize}
\title{Serialize a FHIR Bundle list}
\usage{
fhir_serialize(bundles)
}
\arguments{
\item{bundles}{A list of xml objects representing FHIR bundles as returned by \code{\link{fhir_search}}}
}
\value{
A list of serialized xml objects
}
\description{
Serializes a list of FHIR bundles to allow for saving in .rda or .RData format without losing integrity of pointers
}
\examples{
#example bundles are serialized, unserialize like this:
bundles <- fhir_unserialize(medication_bundles)

#Serialize like this:
bundles_for_saving <- fhir_serialize(bundles)
}
