% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{paste_paths}
\alias{paste_paths}
\title{Concatenate paths}
\usage{
paste_paths(path1 = "w", path2 = "d", os = "LiNuX")
}
\arguments{
\item{path1}{A a character vector of length one specifying the left hand part of the resulting path.}

\item{path2}{A a character vector of length one specifying the right hand part of the resulting path.}

\item{os}{A a character vector of length one specifying the operating system you're operating on: windows or linux.}
}
\value{
A a character vector of length one containing the concatenated path.
}
\description{
Concatenates two strings to a path string correctly.
}
\examples{
paste_paths(path1 = "data", path2 = "patients")
paste_paths(path1 = "/data", path2 = "patients")
paste_paths(path1 = "/data/", path2 = "patients")
paste_paths(path1 = "/data", path2 = "/patients")
paste_paths(path1 = "/data/", path2 = "/patients/")
paste_paths(path1 = "data", path2 = "patients", os = "windows")
}
