% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_resources.R
\name{fhir_build_resource}
\alias{fhir_build_resource}
\title{Build a single FHIR resource}
\usage{
fhir_build_resource(row, brackets, resource_type)
}
\arguments{
\item{row}{Single row from a wide table as produced by \code{\link[=fhir_crack]{fhir_crack()}} with \code{format="wide"}}

\item{brackets}{A character vector of length one. The brackets used for cracking.}

\item{resource_type}{A character vector of length one or \linkS4class{fhir_resource_type} object
indicating which resource type the table is build from.}
}
\value{
A \linkS4class{fhir_resource_xml} object.
}
\description{
This function takes a single row from a wide table as produced by \code{\link[=fhir_crack]{fhir_crack()}} and builds a \linkS4class{fhir_resource_xml} object from it. The column names of the table
must represent the XPath expression of the respective element with indices for repeating items. A table like this is produced when FHIR resources have
been cracked with \code{\link[=fhir_crack]{fhir_crack()}} without assigning explicit column names in the \linkS4class{fhir_design}/\linkS4class{fhir_table_description} and with \code{format} set to \code{"wide"}.
}
\examples{
#unserialize example
bundles <- fhir_unserialize(bundles = example_bundles1)

#crack fhir resources
Pat <- fhir_table_description(
    resource = "Patient",
    brackets = c("[", "]"),
    sep      = " ",
    format   = "wide"
)

df <- fhir_crack(bundles = bundles, design = Pat)


#build resource
resource <- fhir_build_resource(
                row           = df[1,],
                brackets      = c('[', ']'),
                resource_type = "Patient"
            )

#print to console
resource
}
\seealso{
\code{\link[=fhir_cast]{fhir_cast()}}, \code{\link[=fhir_crack]{fhir_crack()}}, \code{\link[=fhir_build_bundle]{fhir_build_bundle()}}, \code{\link[=fhir_post]{fhir_post()}}, \code{\link[=fhir_put]{fhir_put()}}
}
