% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhir_table_description.R
\name{fhir_table_description}
\alias{fhir_table_description}
\title{Create \linkS4class{fhir_table_description} object}
\usage{
fhir_table_description(
  resource,
  cols = fhir_columns(),
  sep = ":::",
  brackets = character(),
  rm_empty_cols = FALSE,
  format = "compact",
  keep_attr = FALSE,
  style = deprecated()
)
}
\arguments{
\item{resource}{A character vector of length one or \linkS4class{fhir_resource_type} object
indicating which resource type should be extracted.}

\item{cols}{Optional. A \linkS4class{fhir_columns} object or something that can be coerced to one,
like a (named) character vector, a (named) list containing xpath expressions,
or a \linkS4class{fhir_xpath_expression} object. See \code{\link[=fhir_columns]{fhir_columns()}} and the examples.
If this argument is omitted, an empty \linkS4class{fhir_columns} object will be supplied.
This means that in the call to \code{\link[=fhir_crack]{fhir_crack()}}, all available elements are extracted in put
in automatically named columns.}

\item{sep}{A character of length one containing the separator string used for separating multiple entries in cells when \code{format = "compact"}.
ignored when \code{format = "wide"}. Defaults to \code{":::"}.}

\item{brackets}{A character of length one or two used for the indices of multiple entries. The first one is the opening bracket
and the second one the closing bracket. Vectors of length one will be recycled.
Defaults to \code{character(0)}, i.e. no brackets, meaning that multiple entries won't be indexed.}

\item{rm_empty_cols}{A logical of length one indicating whether empty columns should be removed from the resulting table or not. Defaults to \code{FALSE}.}

\item{format}{A character of length one indicating whether the resulting table should be cracked to a \code{"wide"} or \code{"compact"} format.
\code{"wide"} means multiple entries will be distributed over several columns with indexed names. \code{"compact"} means multiple entries will be pasted into one cell/column separated by \code{sep} .
Defaults to \code{"compact"}.}

\item{keep_attr}{A logical of length one indicating whether the attribute name of the respective element (\verb{@value} in most cases)
should be attached to the name of the variable in the resulting table. Defaults to \code{FALSE}.}

\item{style}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
An object of class \linkS4class{fhir_table_description}.
}
\description{
A \code{fhir_table_description} holds the information \code{\link[=fhir_crack]{fhir_crack()}} needs to flatten (aka crack)
FHIR resources from a FHIR bundle. There should be one \code{fhir_table_description} per resource type as
\code{\link[=fhir_crack]{fhir_crack()}} will create one data.frame/data.table per resource type in a bundle. See Details.
}
\details{
A \code{fhir_table_description} consists of
the following elements:
\itemize{
\item The resource element: Defines the resource type (e.g. \code{Patient} or \code{Observation}). See \code{\link[=fhir_resource_type]{fhir_resource_type()}}.
\item The cols element: Contains the column names and XPath expressions defining the columns to extract.
If this element is empty, \code{\link[=fhir_crack]{fhir_crack()}} will extract all available elements of the resource and name the
columns automatically. See \code{\link[=fhir_columns]{fhir_columns()}}.
\item The sep element: A character of length one containing the separator string used for separating multiple entries in cells.
\item The brackets element: A character of length one or two used for the indices of multiple entries. The first one is the opening bracket
and the second one the closing bracket. Vectors of length one will be recycled.
Defaults to \code{character(0)}, i.e. no brackets, meaning that multiple entries won't be indexed.
\item The rm_empty_cols element: A logical of length one indicating whether empty columns should be removed in the resulting table or not. Defaults to \code{FALSE}.
\item The format element: A character of length one indicating whether the resulting table should be cracked to a \code{wide} or \code{compact} format.
\code{wide} means multiple entries will be distributed over several columns with indexed names. \code{compact} means multiple entries will be pasted into one cell/column separated by \code{sep} .
Defaults to \code{compact}.
\item The keep_attr element: A logical of length one indicating whether the attribute name of the respective element (\verb{@value} in most cases)
should be attached to the name of the variable in the resulting table. Defaults to \code{FALSE}.
}

A full \code{fhir_table_description} looks for example like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fhir_resource_type: Patient

fhir_columns:
column name | xpath expression
------------------------
name        | name/family
gender      | gender
id          | id

sep:           ':::'
brackets:      '[', ']'
rm_empty_cols: FALSE
format:        'compact'
keep_attr:     FALSE
}\if{html}{\out{</div>}}
}
\examples{
# a minimal table description
fhir_table_description(
    resource = "Patient"
)

# named list for cols
fhir_table_description(
    resource = "Patient",
    cols     = list(
        id     = "id",
        name   = "name/family",
        gender = "gender"
    )
)

#unnamed character for cols, colnames are generated automatically
fhir_table_description(
    resource = "Patient",
    cols     = c(
        "id",
        "name/family",
        "gender"
    )
)

# named character for cols, and overwritten default for other arguments
fhir_table_description(
    resource = "Patient",
    cols = c(
        id            = "id",
        name          = "name/family",
        gender        = "gender"
    ),
    brackets      = c("[", "]"),
    rm_empty_cols = TRUE,
    format        = "wide"
)

# no column arguments is given -> creates a column for all available elements
fhir_table_description(
    resource = "Patient",
    sep           = " <~> ",
    brackets      = c("<<<", ">>>"),
    rm_empty_cols = FALSE,
    format        = "wide"
)

}
