% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.fic}
\alias{summary.fic}
\title{Summarise focused model comparison results}
\usage{
\method{summary}{fic}(object, tidy = TRUE, adj = FALSE, ...)
}
\arguments{
\item{object}{Object returned by \code{\link{fic}} representing focused model comparison statistics for a range of models, and potentially also multiple focus quantities.}

\item{tidy}{If \code{TRUE} (the default) then the results describing the optimal model (per focus) are returned as a data frame, with the names of the parameters in the optimal model collapsed into a single string.  If \code{FALSE}, the results are returned as a list, including a vector of parameter names.}

\item{adj}{The optimal model is the one with the lowest root mean square error (RMSE). If \code{adj=TRUE} the RMSE is based on the adjusted bias estimator.  Otherwise the standard estimator is used.}

\item{...}{Other arguments, currently unused.}
}
\value{
A list of two components, one for the optimal model per focus, and one for the range of focus and RMSE estimates over models.
}
\description{
Summarise focused model comparison results
}
\examples{

## Example from the main vignette, see there for more details

wide.glm <- glm(low ~ lwtkg + age + smoke + ht + ui + smokeage + smokeui,
                data=birthwt, family=binomial)
vals.smoke <-    c(1, 58.24, 22.95, 1, 0, 0, 22.95, 0)
vals.nonsmoke <- c(1, 59.50, 23.43, 0, 0, 0, 0, 0)
X <- rbind("Smokers" = vals.smoke, "Non-smokers" = vals.nonsmoke)
inds0 <- c(1,1,0,0,0,0,0,0)
combs <- all_inds(wide.glm, inds0)
ficres <- fic(wide = wide.glm, inds = combs, inds0 = inds0,
              focus = prob_logistic, X = X)
ggplot_fic(ficres)
summary(ficres)

}
\seealso{
\code{\link{ggplot_fic}}, \code{\link{plot.fic}} for a more detailed visual representation of the focused comparison
}
