% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erosionFilter.R
\name{erosionFilter}
\alias{erosionFilter}
\title{erosionFilter}
\usage{
erosionFilter(x)
}
\arguments{
\item{x}{Object of class \emph{RasterLayer}.}
}
\value{
A \emph{RasterLayer}.
}
\description{
Applies an erosion and dilation filter over a raster object.
}
\details{
{For each unique, non-NA value in \emph{x} the function derives a mask, 
erodes it and dilates it simplifying the shape of the corresponding pixels.}
}
\examples{
{

require(raster)

# read raster data
r <- brick(system.file("extdata", "ndvi.tif", package="fieldRS"))

# spatial change labeling
or <- ccLabel(r[[1]], method="spatial", change.threshold=50)$regions

# convert to polygons and plot
er <- erosionFilter(or)

# plot and compare
plot(or)
plot(er)

}
}
