% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkOverlap.R
\name{checkOverlap}
\alias{checkOverlap}
\title{checkOverlap}
\usage{
checkOverlap(x, y)
}
\arguments{
\item{x}{A spatial object.}

\item{y}{A spatial object.}
}
\value{
A two element numeric \emph{vector}.
}
\description{
Reports on how much two spatial objects overlap.
}
\details{
{Uses \link[raster]{intersect} to report on the percentage of the area
of \emph{x} and \emph{y} that coincides with their common spatial overlap.}
}
\examples{
{

 require(raster)
 
 # build polygons
 df1 <- data.frame(x=c(1, 5, 10, 2, 1), y=c(10, 9, 8, 7, 10))
 df2 <- data.frame(x=c(2, 6, 5, 4, 2), y=c(10, 9, 7, 4, 10))
 p <- list(Polygons(list(Polygon(df1)), ID=1), 
 Polygons(list(Polygon(df2)), ID=2))
 p <- SpatialPolygons(p)

 # check overlap \%
 checkOverlap(p[1,], p[2,])

}
}
