% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_wrap.R
\name{fig_wrap}
\alias{fig_wrap}
\title{Quickly arrange and label multiple figs.}
\usage{
fig_wrap(
  figs,
  tag = NULL,
  prefix = NULL,
  suffix = NULL,
  pos = "topleft",
  x_nudge = 0,
  y_nudge = 0,
  nrow = NULL,
  ncol = NULL,
  colour = NULL,
  alpha = NULL,
  hjust = NULL,
  vjust = NULL,
  fontsize = NULL,
  fontfamily = NULL,
  fontface = NULL,
  b_col = NULL,
  b_size = 1,
  b_pos = "offset",
  b_margin = ggplot2::margin(4, 4, 4, 4)
)
}
\arguments{
\item{figs}{List of figs from \code{fig()}.}

\item{tag}{Tags to be applied to figs. Begins with first uppercase or
lowercase letter supplied, or number, and continues the sequence. "A"
labels them 'A', 'B', etc. "c" labels them 'c', 'd', 'e' etc.}

\item{prefix}{Prefix for each tag}

\item{suffix}{Suffix for each tag}

\item{pos}{Position for label, to be passed to \code{fig_tag()}.}

\item{x_nudge}{Minor adjustments to the x position in relative plot
coordindates (0 being furthest left, 1 being furthest right).}

\item{y_nudge}{Minor adjustments to the y position in relative plot
coordinates (0 being the bottom, 1 being the top).}

\item{nrow}{Number of rows in final patchwork.}

\item{ncol}{Number of cols in final patchwork.}

\item{colour}{Colour for each tag}

\item{alpha}{Alpha for each tag}

\item{hjust}{hjust for each tag}

\item{vjust}{vjust for each tag}

\item{fontsize}{Fontsize for each tag}

\item{fontfamily}{Fontfamily for each tag}

\item{fontface}{Fontface for each tag}

\item{b_col}{Colour of individual fig borders.}

\item{b_size}{Size of individual fig borders (in mm).}

\item{b_pos}{Either "offset" and expanding outwards from borders of figure,
or "inset" and expanding inwards and partially covering the figure.}

\item{b_margin}{Margins to adjust around the figs. Use
\code{ggplot2::margin()}}
}
\value{
\code{patchwork} patch of supplied figs.
}
\description{
Quickly arrange and label multiple figs.
}
\examples{

library(figpatch)
library(ggplot2)

# Attach the fig image file
image <- system.file("extdata", "fig.png", package = "figpatch", mustWork = TRUE)

# Read in the image as a 'fig'
img <- fig(image)

# multiple figs
figs <- lapply(1:9, function(x) img)

# wrap the figs
fig_wrap(figs)

# Wrap the figs and auto-tag
fig_wrap(figs, tag = "A", suffix = ")")

# Wrap figs, auto-tag and adds border.
fig_wrap(figs, tag = 1, prefix = "(", suffix = ")", b_col = "black")
}
