% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{dot.plot}
\alias{dot.plot}
\title{dot.plot}
\usage{
dot.plot(
  parent.df = dot.df.melt,
  category.col = "Treatment",
  y.rank.col = "rank",
  y.label.rank.col = "label.rank",
  y.label.col = "subgroup",
  Point.Est = "percent",
  x.limits = c(0, 1),
  x.ticks = seq(0, 1, 0.2),
  y.limits = NULL,
  shape.palette = c(16, 17),
  x.label = "Estimate",
  y.label = "Item",
  category.palette = c("red", "blue")
)
}
\arguments{
\item{parent.df}{data.frame used by ggplot}

\item{category.col}{data.frame column associated with categorical variable (bar.plot, box.plot, cdf.plot, dot.plot, km.plot)}

\item{y.rank.col}{column holding ranks for line items in forest/dot/table plots}

\item{y.label.rank.col}{column holding ranks for labels in forest/dot/table plots}

\item{y.label.col}{column holding labels for forest/dot/table plots}

\item{Point.Est}{point estimate}

\item{x.limits}{value gets passed to scale_x_continuous}

\item{x.ticks}{value gets passed to scale_x_continuous}

\item{y.limits}{passed to scale_y_continuous}

\item{shape.palette}{values passed to scale_shape_manual}

\item{x.label}{value gets passed to labs}

\item{y.label}{value gets passed to labs}

\item{category.palette}{colors assoicated with categorical variable}
}
\value{
A ggplot object is returned.
}
\description{
A function for creating harmonized ggplot2 dot plots with compatiability with table.plot and forest.plot.
}
\author{
Greg Cicconetti
}
