% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qiime2meco.R
\name{qiime2meco}
\alias{qiime2meco}
\title{Transform 'QIIME2' results to 'microtable' object.}
\usage{
qiime2meco(
  ASV_data,
  sample_data = NULL,
  taxonomy_data = NULL,
  phylo_tree = NULL,
  rep_fasta = NULL,
  ...
)
}
\arguments{
\item{ASV_data}{the ASV data, such as the data2_table.qza.}

\item{sample_data}{default NULL; the sample metadata table, such as the sample-metadata.tsv.}

\item{taxonomy_data}{default NULL; the taxonomy data, such as the taxonomy.qza.}

\item{phylo_tree}{default NULL; the phylogenetic tree, such as the tree.qza.}

\item{rep_fasta}{default NULL; the representative sequences, such as the dada2_rep_set.qza.}

\item{...}{parameter passed to microtable$new function of microeco package, such as auto_tidy parameter.}
}
\value{
microtable object.
}
\description{
Transform 'QIIME2' qza results to microtable object.
}
\examples{
\dontrun{
# The data files is downloaded from https://docs.qiime2.org/2020.8/tutorials/pd-mice/ 
#   and stored inside the package.
abund_file_path <- system.file("extdata", "dada2_table.qza", package="file2meco")
sample_file_path <- system.file("extdata", "sample-metadata.tsv", package="file2meco")
taxonomy_file_path <- system.file("extdata", "taxonomy.qza", package="file2meco")
qiime2meco(ASV_data = abund_file_path)
qiime2meco(ASV_data = abund_file_path, sample_data = sample_file_path)
qiime2meco(ASV_data = abund_file_path, sample_data = sample_file_path, 
  taxonomy_data = taxonomy_file_path)
}
}
