% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{PutInPos}
\alias{PutInPos}
\title{Put specified strings in specified positions}
\usage{
PutInPos(strings, positions)
}
\arguments{
\item{strings}{A charachter vector of the strings to put in positions
(coerced by \link{as.character} if not charachter already).}

\item{positions}{The indices of the charachter vector to be occupied by the
elements of strings. Must be the same length as strings or of length 1.}
}
\value{
A charachter vector.
}
\description{
Create a charachter vector with a set of strings at specified positions in
that charachter vector, with the rest of it taken up by empty strings.
}
\examples{
PutInPos(1:3, c(1, 8, 9))
PutInPos(c("Apple", "Orange", "County"), c(5, 7, 8))
PutInPos(1:2, 5)
}
