% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{ExtractNumbers}
\alias{ExtractNumbers}
\alias{ExtractNonNumerics}
\alias{NthNumber}
\alias{NthNonNumeric}
\title{Extract numbers (or non-numbers) from a string.}
\usage{
ExtractNumbers(string, leave.as.string = FALSE, decimals = FALSE,
  leading.decimals = FALSE, negs = FALSE)

ExtractNonNumerics(string, decimals = FALSE, leading.decimals = FALSE,
  negs = FALSE)

NthNumber(string, n = 1, leave.as.string = FALSE, decimals = FALSE,
  leading.decimals = FALSE, negs = FALSE)

NthNonNumeric(string, n = 1, decimals = FALSE, leading.decimals = FALSE,
  negs = FALSE)
}
\arguments{
\item{string}{A string.}

\item{leave.as.string}{Do you want to return the number as a string (\code{TRUE})
or as numeric (\code{FALSE}, the default)?}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading.decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{n}{The index of the number (or non-numeric) that you seek. Negative
indexing is allowed i.e. \code{n = 1} (the default) will give you the first
number (or non-numeric) whereas \code{n = -1} will give you the last number (or
non-numeric), \code{n = -2} will give you the second last number and so on.}
}
\value{
For \code{ExtractNumbers} and \code{ExtractNonNumerics}, a list of numeric or
character vectors, one list element for each element of \code{string}. For
\code{NthNumber} and \code{NthNonNumeric}, a vector the same length as \code{string} (as
in \code{length(string)}, not \code{nchar(string)}).
}
\description{
\code{ExtractNumbers} extracts the numbers (or non-numbers) from a string where
decimals are optionally allowed. \code{ExtractNonNumerics} extracts the bits of
the string that aren't extracted by \code{ExtractNumbers}. \code{NthNumber} is a
convenient wrapper for \code{ExtractNumbers}, allowing you to choose which number
you want. Similarly \code{NthNonNumeric}. Please view the examples at the bottom
of this page to ensure that you understand how these functions work, and
their limitations. These functions are vectorised over \code{string}.
}
\details{
If any part of a string contains an ambiguous number (e.g. \code{1.2.3} would be
ambiguous if \code{decimals = TRUE} (but not otherwise)), the value returned for
that string will be \code{NA}. Note that these functions do not know about
scientific notation (e.g. \code{1e6} for 1000000).
}
\examples{
ExtractNumbers(c("abc123abc456", "abc1.23abc456"))
ExtractNumbers(c("abc1.23abc456", "abc1..23abc456"), decimals = TRUE)
ExtractNumbers("abc1..23abc456", decimals = TRUE)
ExtractNumbers("abc1..23abc456", decimals = TRUE, leading.decimals = TRUE)
ExtractNumbers("abc1..23abc456", decimals = TRUE, leading.decimals = TRUE,
leave.as.string = TRUE)
ExtractNumbers("-123abc456")
ExtractNumbers("-123abc456", negs = TRUE)
ExtractNumbers("--123abc456", negs = TRUE)
ExtractNonNumerics("abc123abc456")
ExtractNonNumerics("abc1.23abc456")
ExtractNonNumerics("abc1.23abc456", decimals = TRUE)
ExtractNonNumerics("abc1..23abc456", decimals = TRUE)
ExtractNonNumerics("abc1..23abc456", decimals = TRUE,
leading.decimals = TRUE)
ExtractNonNumerics(c("-123abc456", "ab1c"))
ExtractNonNumerics("-123abc456", negs = TRUE)
ExtractNonNumerics("--123abc456", negs = TRUE)
ExtractNumbers(c(rep("abc1.2.3", 2), "a1b2.2.3", "e5r6"), decimals = TRUE)
ExtractNumbers("ab.1.2", decimals = TRUE, leading.decimals = TRUE)
NthNumber("abc1.23abc456", 2)
NthNumber("abc1.23abc456", 2, decimals = TRUE)
NthNumber("-123abc456", -2, negs = TRUE)
ExtractNonNumerics("--123abc456", negs = TRUE)
NthNonNumeric("--123abc456", 1)
NthNonNumeric("--123abc456", -2)
}
