% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{GroupClose}
\alias{GroupClose}
\title{Group together close adjacent elements of a vector.}
\usage{
GroupClose(vec.ascending, max.gap = 1)
}
\arguments{
\item{vec.ascending}{A strictly increasing numeric vector.}

\item{max.gap}{The biggest allowable gap between adjacent elements for them
to be considered part of the same \emph{group}.}
}
\value{
A where each element is one group, as a numeric vector.
}
\description{
Given a strictly increasing vector (each element is bigger than the last),
group together stretches of the vector where \emph{adjacent} elements are
separeted by at most some specified distance. Hence, each element in each
group has at least one other element in that group that is \emph{close} to
it. See the examples.
}
\examples{
GroupClose(1:10, 1)
GroupClose(1:10, 0.5)
GroupClose(c(1, 2, 4, 10, 11, 14, 20, 25, 27), 3)
}
