% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{paste_different_lengths}
\alias{paste_different_lengths}
\title{Paste vectors/files with different lengths/numbers of lines.}
\usage{
paste_different_lengths(files, sep = "")
}
\arguments{
\item{files}{A character vector of files to be read in via \code{readLines}
to be pasted. If you would like to use this function on vectors already in
the environment (without reading in files), pass them into this argument as
a list (see the examples).}

\item{sep}{What (if anything) do you want to paste in between things as
you're pasting them together.}
}
\value{
A character vector.
}
\description{
Paste character vectors of different lengths, optionally inputting the
vectors as file names, which become character vectors via \code{readLines}.
Vectors are first extended to all be the same length via
\code{\link[=ExtendCharVec]{ExtendCharVec()}} and are then pasted together, with no separator
put in when pasting empty strings. See the examples if you don't understand.
}
\examples{
paste_different_lengths(list(1:3, 1:4))
paste_different_lengths(list(1:3, 1:4), sep = "sSs")
setwd(tempdir())
writeLines(as.character(1:3), "PasteDifferentLengths1.txt")
writeLines(as.character(1:4), "PasteDifferentLengths2.txt")
paste_different_lengths(list.files(pattern = "PasteDifferentLengths"),
                        sep = "sSsepPp")
# clean up working directory
file.remove(list.files(pattern = "PasteDifferentLengths"))
}
