% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{remove_filename_spaces}
\alias{remove_filename_spaces}
\title{Remove spaces in file names}
\usage{
remove_filename_spaces(dir = ".", pattern = "", replacement = "")
}
\arguments{
\item{dir}{The directory in which to perform the operation.}

\item{pattern}{A regular expression. If specified, only files matching this
pattern will be treated.}

\item{replacement}{What do you want to replace the spaces with? This
defaults to nothing, another sensible choice would be an underscore.}
}
\value{
A logical vector indicating which operation succeeded for each of the
files attempted. Using a missing value for a file or path name will always
be regarded as a failure.
}
\description{
Remove spaces in file names in a specified directory, replacing them with
whatever you want, default nothing.
}
\examples{
\dontrun{
dir.create("RemoveFileNameSpaces_test")
setwd("RemoveFileNameSpaces_test")
files <- c("1litres 1.txt", "1litres 30.txt", "3litres 5.txt")
file.create(files)
remove_filename_spaces()
list.files()
setwd("..")
dir.remove("RemoveFileNameSpaces_test")
}
}
