% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r0_conversions.R
\name{lambda_to_r0}
\alias{lambda_to_r0}
\title{Calculate \eqn{R_0} from transmission rate (\eqn{\lambda})}
\usage{
lambda_to_r0(
  lambda,
  contact_matrix,
  demography_vector,
  susceptibility,
  p_susceptibility,
  infectious_period = 1.8
)
}
\arguments{
\item{lambda}{The transmission rate of the disease, also called the 'force of
infection' (\eqn{\lambda}). This is different from the effective
transmission rate (\eqn{\beta}).}

\item{contact_matrix}{Social contact matrix. Entry \eqn{m_{ij}} gives average
number of contacts in group \eqn{i} reported by participants in group \eqn{j}}

\item{demography_vector}{Demography vector. Entry \eqn{v_{i}} gives
proportion of total population in group \eqn{i}.}

\item{susceptibility}{A matrix giving the susceptibility of individuals in
demographic group \eqn{i} and risk group \eqn{k}.}

\item{p_susceptibility}{A matrix giving the probability that an individual
in demography group \eqn{i} is in risk (or susceptibility) group \eqn{k}.
Each row represents the overall distribution of individuals in demographic
group \eqn{i} across risk groups, and each row \emph{must sum to 1.0}.}

\item{infectious_period}{Duration of the infectious period in days.
Default value is 1.8 days.}
}
\value{
Returns the \eqn{R_0} for the infection in the population.
}
\description{
Uses the transmission rate (\eqn{\lambda}), social contacts
matrix (\eqn{c}), demography (\eqn{N}), the distribution \eqn{P} of each
demographic group \eqn{i} into susceptibility groups \eqn{S}, and the
infectious period (\eqn{\gamma}) to calculate the \eqn{R_0} using the
following equation.
\deqn{R_0 = {Max}(EV(C)) \times \lambda \gamma}
where \eqn{EV(C)} denotes the eigenvalues of the matrix \eqn{C} which is
calculated from the social contacts matrix scaled by the number of
individuals in each demographic and susceptibility group in the population.
}
\examples{
# Get example dataset and prepare contact matrix and demography
data(polymod_uk)
contact_matrix <- polymod_uk$contact_matrix
demography_vector <- polymod_uk$demography_vector

# define lambda
lambda <- 0.3

# define infectious period of 5 days
infectious_period <- 5
# define the number of age and susceptibility groups
n_demo_grps <- length(demography_vector)
n_risk_grps <- 3

# In this example, all risk groups from all age groups are fully
# susceptible
susceptibility <- matrix(
  data = 1, nrow = n_demo_grps, ncol = n_risk_grps
)

p_susceptibility <- matrix(
  data = 1, nrow = n_demo_grps, ncol = n_risk_grps
)
# p_susceptibility rows must sum to 1.0
p_susceptibility <- p_susceptibility / rowSums(p_susceptibility)

lambda_to_r0(
  lambda, contact_matrix, demography_vector,
  susceptibility, p_susceptibility,
  infectious_period
)

}
